<?php
/**
 * ļϵͳ
 *
 * @author һ yandy@yanwee.com
 * @package 1.0
 * @version $Id$
 */

require_once('FileSystem.class.php');
/**
 * UploadFile ϴ
 * @package Util
 */
class UploadFile {
	/**
	 * ϴļ
	 * @var array $allowFileTypes 
	 * @access private
	 */
	private $allowFileTypes = array('jpeg','jpg','gif','bmp','png');

	/**
	 * ϴļСλֽ
	 * @var int $maxFileSize 
	 * @access public
	 */
	public $maxFileSize = 8388608;

	/**
	 * 캯
	 */
	public function __construct() {

	}

	/**
	 * ļ
	 * @param mixed $fileTypes ļбַá,Ÿ
	 * @return void 
	 * @access public
	 */
	public function setAllowFileType($fileTypes) {
		if (!is_array($fileTypes)) {
			$this->allowFileTypes = explode(',', $fileTypes);
		} else {
			$this->allowFileTypes = $fileTypes;
		}
		return;
	}

	/**
	 * ϴļ
	 * @param string $fileField  Ҫϴļ$_FILES['file']
	 * @param string $destFolder ϴĿ¼Զ
	 * @param string $fileTypes   ϴļʽ0ʹԭļ1ʹõǰʱΪļ
	 * @return int 
	 * @access public
	 */
	public function upload($fileField, $destFolder = './', $fileNameType = 1) {

		switch ($fileField['error']) {
			case UPLOAD_ERR_OK : //ֵΪ 0ûдļϴɹ
			$upload_succeed = true;
			break;
			case UPLOAD_ERR_INI_SIZE : //ֵΪ 1ϴļ php.ini  upload_max_filesize ѡƵֵ
			case UPLOAD_ERR_FORM_SIZE : //ֵΪ 2ϴļĴС HTML  MAX_FILE_SIZE ѡֵָ
			$errorMsg = 'ļϴʧܣʧԭļСƣ';
			$errorCode = -103;
			$upload_succeed = false;
			break;
			case UPLOAD_ERR_PARTIAL : //ֵ3; ļֻвֱϴ
			$errorMsg = 'ļϴʧܣʧԭļֻвֱϴ';
			$errorCode = -101;
			$upload_succeed = false;
			break;
			case UPLOAD_ERR_NO_FILE : //ֵ4; ûļϴ
			$errorMsg = 'ļϴʧܣʧԭûļϴ';
			$errorCode = -102;
			$upload_succeed = false;
			break;
			case UPLOAD_ERR_NO_TMP_DIR : //ֵΪ 6ҲʱļСPHP 4.3.10  PHP 5.0.3 
			$errorMsg = 'ļϴʧܣʧԭҲʱļУ';
			$errorCode = -102;
			$upload_succeed = false;
			break;
			case UPLOAD_ERR_CANT_WRITE : //ֵΪ 7ļдʧܡPHP 5.1.0 
			$errorMsg = 'ļϴʧܣʧԭļдʧܣ';
			$errorCode = -102;
			$upload_succeed = false;
			break;
			default : //
			$errorMsg = 'ļϴʧܣʧԭ';
			$errorCode = -100;
			$upload_succeed = false;
			break;
		}
		if ($upload_succeed) {
			if ($fileField['size']>$this->maxFileSize) {
				$errorMsg = 'ļϴʧܣʧԭļСƣ';
				$errorCode = -103;
				$upload_succeed = false;
			}
			if ($upload_succeed) {
				$fileExt = FileSystem::fileExt($fileField['name']);
				if (!in_array(strtolower($fileExt),$this->allowFileTypes)) {
					$errorMsg = 'ļϴʧܣʧԭļͲ';
					$errorCode = -104;
					$upload_succeed = false;
				}
			}
		}
		if ($upload_succeed) {
			if (!is_dir($destFolder) && $destFolder!='./' && $destFolder!='../') {
				$dirname = '';
				$folders = explode('/',$destFolder);
				foreach ($folders as $folder) {
					$dirname .= $folder . '/';
					if ($folder!='' && $folder!='.' && $folder!='..' && !is_dir($dirname)) {
						mkdir($dirname);
					}
				}
				chmod($destFolder,0777);
			}
			switch ($fileNameType) {
				case 1:
					$fileName = date('YmdHis');
					$dot = '.';
					$fileFullName = $fileName . $dot . $fileExt;
					$i = 0;
					//жǷļ
					while (is_file($destFolder . $fileFullName)) {
						$fileFullName = $fileName . $i++ . $dot . $fileExt;
					}
					break;
				case 2:
					$fileFullName = date('YmdHis');
					$i = 0;
					//жǷļ
					while (is_file($destFolder . $fileFullName)) {
						$fileFullName = $fileFullName . $i++;
					}
					break;
				default:
					$fileFullName = $fileField['name'];
					break;
			}
			if (@move_uploaded_file($fileField['tmp_name'], $destFolder . $fileFullName)) {
				return $fileFullName;
			} else {
				$errorMsg = 'ļϴʧܣʧԭ򣺱ļϵͳдȨ޳';
				$errorCode = -105;
				$upload_succeed = false;
			}
		}
		if (!$upload_succeed) {
			throw new Exception($errorMsg,$errorCode);
		}

	}
}
?>